import pandas as pd  
import matplotlib.pyplot as plt  
from decision_company import read_csv_file, logical_and, check_elements_in_list, filter_by_condition, count_unique_values, create_subplots, set_plot_split_title, set_layout, show_plots, save_plot, fetch_column

# Load the dataset      
credit_customers = read_csv_file("credit_customers.csv")      
  
# Filter customer segments      
middle_aged_condition = logical_and(fetch_column(credit_customers, 'age') > 40, fetch_column(credit_customers, 'age') < 59)  
middle_aged_customers = filter_by_condition(credit_customers, middle_aged_condition)  
  
stable_employment_condition = check_elements_in_list(fetch_column(credit_customers, 'employment'), ['>=7', '4<=X<7'])  
stable_employment_customers = filter_by_condition(credit_customers, stable_employment_condition)  
  
good_credit_history_condition = check_elements_in_list(fetch_column(credit_customers, 'credit_history'), ['existing paid', 'no credits/all paid', 'all paid'])  
good_credit_history_customers = filter_by_condition(credit_customers, good_credit_history_condition)  
  
# Calculate approval rates      
approval_rates_middle_aged = count_unique_values(fetch_column(middle_aged_customers, 'class'), normalize=True)      
approval_rates_stable_employment = count_unique_values(fetch_column(stable_employment_customers, 'class'), normalize=True)      
approval_rates_good_credit_history = count_unique_values(fetch_column(good_credit_history_customers, 'class'), normalize=True)      
  
# Plot pie charts      
fig, axes = create_subplots(1, 3, figsize=(18, 6))      
  
approval_rates_middle_aged.plot(kind='pie', ax=axes[0], autopct='%.1f%%', startangle=90, ylabel='')      
set_plot_split_title(axes[0], 'Loan Approval Rates for Middle-Aged Customers (40-59)')      
  
approval_rates_stable_employment.plot(kind='pie', ax=axes[1], autopct='%.1f%%', startangle=90, ylabel='')      
set_plot_split_title(axes[1], 'Loan Approval Rates for Customers with Stable Employment')      
  
approval_rates_good_credit_history.plot(kind='pie', ax=axes[2], autopct='%.1f%%', startangle=90, ylabel='')      
set_plot_split_title(axes[2], 'Loan Approval Rates for Customers with Good/Excellent Credit History')      
  
set_layout()     
save_plot('ref_result/pieplot.png')     
show_plots()  
 